//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define FileBufferSize    512

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool SendFileData(char *FileName)
{
    FILE *SourceHandle = NULL;

    char StatusText[255];

    WriteLog("Begining file transfer.");

	if( (SourceHandle = fopen(FileName, "rb")) == NULL)
    {
        WriteLog("Failed to open export file for binary read");
        return false;
    }

    int BytesRead = 0;
    int ReceiveSize = 0;

    char *FileBuffer  = NULL;

    glDataCRC = 0xffffffff;

    FileBuffer = (char *) calloc(FileBufferSize + 1, 1);

    MyClient.RawMode = true;

    do{
        if(MyClient.PeekSizeOfSendData() == 0)
        {
            BytesRead = fread(FileBuffer, sizeof(char), FileBufferSize, SourceHandle);
            glDataCRC = PartialCRC(glDataCRC, FileBuffer, BytesRead);
            ClientSend(FileBuffer, BytesRead);
        }
        else Sleep(1);
    } while(BytesRead == FileBufferSize && MyClient.Connected);


    // Wait for all data to be sent before switching from RawMode
    while(MyClient.PeekSizeOfSendData() != 0 && MyClient.Connected)
    {
        Sleep(1);
    }

    MyClient.RawMode = false;

    glDataCRC = (glDataCRC ^ 0xffffffff);

    free(FileBuffer);
    FileBuffer = NULL;

    if(SourceHandle) fclose(SourceHandle);
    SourceHandle = NULL;

    Sleep(1000);

    if(MyClient.Connected == false)
    {
        WriteLog("Disconnected during file transfer.");
        return false;
    }

    sprintf(StatusText, "File transfer complete. CRC: %x", glDataCRC);
    WriteLog(StatusText);

    return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

